<?php
// $Id$

/**
 * @author AdSpeed.com
 *
 * @file
 * Manage AdSpeed ads on Drupal-powered website
 */

/**
 * Setups the setting form
 */
function _adspeed_settings() {
  $form['blocks'] = array(
	'#title'        => t('Ad Zones'),
	'#type'         => 'fieldset',
    '#description'  => '',
  );
  $zones_num = variable_get('adspeed_num_zones', 3);
  $form['blocks']['adspeed_num_zones'] = array(
	'#title'          => t('Number of ad zones to configure'),
    '#default_value'  => $zones_num,
    '#description'    => '',
    '#type'           => 'textfield',
    '#size'           => 6,
  );

  $form['blocks']['adspeed_zones'] = array(
    '#tree'         => TRUE,
    '#theme'        => 'adspeed_settings_zones',
  );
  $zones = variable_get('adspeed_zones', array());
  for ($i = 0; $i < $zones_num; $i++) {
    $form['blocks']['adspeed_zones'][$i]['id'] = array(
      '#type'           => 'textfield',
      '#default_value'  => $zones[$i]['id'],
      '#size'           => 6,
    );
  }

  return system_settings_form($form);
}

/**
 * Displays as a table
 */
function theme_adspeed_settings_zones($form) {
  $header = array(t('Zone ID'));
  foreach (element_children($form) as $zone) {
    $rows[] = array(drupal_render($form[$zone]['id']));
  }
  $output .= theme('table', $header, $rows);
  return $output;
}

