# AdSpeed Ad Server Plugin for MovableType
# Author: AdSpeed.com
# Author URI: http://www.AdSpeed.com
# License: GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html

package AdSpeed::Plugin;
use strict;

#############################################################
=head2 AdSpeed

This tag outputs the AdSpeed serving code for a given zone

=cut

sub tag {
	my ($ctx, $args) = @_;
	my $plugin = MT->component('AdSpeed');
	my $blog = $ctx->stash('blog');
	my $username = $plugin->get_config_value('AdSpeed_username','blog:' . $blog->id);
		
	if(!$args->{'zone_id'}) {
		return $ctx->error("Zone ID is required");
	}
	my $zid = $args->{'zone_id'};
	my $target = '_top';
	my $custom = '';
	
	if($args->{'target'}) {
		$target = $args->{'target'};
	}
	if($args->{'custom'}) {
		$custom = $args->{'custom'};
	}
	
	my $code = '<div class="AdSpeedMT">';
	$code .= '<!-- AdSpeed.com MT Serving Code 7.9.4 for [Zone] #' . $zid . ' [Any Dimension] -->';
	$code .= '<script type="text/javascript" src="http://g.adspeed.net/ad.php?do=js&zid=' . $zid . '&wd=-1&ht=-1&target=' . $target . '&cb=' . time . $custom . '"></script>';
	$code .= '<!-- AdSpeed.com End --></div>';
	
	return $code;
}

1; 
